<?php
/**
 * Module Name: BuddyPress Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( function_exists( 'buddypress' ) ) :

 //*************** Actions ***************\\
 add_action('bp_activity_posted_update','wpachievements_my_bp_update_post_add', 10, 3);
 add_action('bp_activity_comment_posted','wpachievements_my_bp_update_comment_add', 10, 1);
 add_action('bp_activity_action_delete_activity','wpachievements_my_bp_delete_comment_add', 10, 2);
 add_action('groups_group_create_complete','wpachievements_my_bp_create_group_add');
 add_action('groups_delete_group','wpachievements_my_bp_create_group_remove', 10 , 2);
 add_action('groups_join_group','wpachievements_my_bp_join_group_add', 10, 2);
 add_action('groups_membership_accepted','wpachievements_my_bp_join_non_public_group_add', 10, 2);
 add_action('groups_accept_invite','wpachievements_my_bp_join_non_public_group_add', 10, 2);
 add_action('groups_leave_group','wpachievements_my_bp_leave_group_add_cppoints', 10, 2);
 add_action('bp_groups_posted_update','wpachievements_my_bp_update_group_add', 10, 4);
 add_action('friends_friendship_accepted','wpachievements_my_bp_friend_add', 10, 3);
 add_action('friends_friendship_deleted','wpachievements_my_bp_friend_delete_add', 10, 3);
 add_action('bp_forums_new_topic','wpachievements_my_bp_forum_new_topic_add');
 add_action('bp_forums_new_post','wpachievements_my_bp_forum_new_post_add');
 add_action('groups_edit_forum_topic','wpachievements_my_bp_forum_edit_topic_add');
 add_action('xprofile_avatar_uploaded','wpachievements_my_bp_avatar_add');
 add_action('groups_screen_group_admin_avatar','wpachievements_my_bp_group_avatar_add');
 add_action('messages_message_sent','wpachievements_my_bp_pm');

// Filter the user ID on profile pages
add_filter( 'wpachievements_shortcode_user_id', 'wpachievements_bp_shortcode_user_id' );
// Register an achievements tab
add_action( 'bp_setup_nav', 'wpachievements_bp_extend_navigation', 99 );

/**
 * Filter the shortcode user id on user pages.
 * This makes sure that the data of displayed user are displaye instead of the logged in user
 *
 * @param  integer $user_id User ID
 * @return integer          User ID
 */
function wpachievements_bp_shortcode_user_id( $user_id ) {

  if ( ! function_exists( 'bp_displayed_user_id' ) || ! function_exists( 'is_buddypress' ) ) {
    return $user_id;
  }

  if ( is_buddypress() ) {
    $displayed_user = bp_displayed_user_id();

    if ( $displayed_user ) {
      $user_id = $displayed_user;
    }
  }

  return $user_id;
}

function wpachievements_bp_extend_navigation() {

  if ( function_exists('bp_core_new_nav_item') &&  ( 'Disable' != wpachievements_get_site_option('wpachievements_bp_show_achievements_tab') || 'Disable' != wpachievements_get_site_option('wpachievements_bp_show_quests_tab') ) ) {

    bp_core_new_nav_item( array(
      'name' => __('Badges', 'wpachievements' ),
      'slug' => 'wpa-badges',
      'position' => 10,
      'show_for_displayed_user' => true,
      'screen_function' => 'wpachievements_bp_display_achievements',
      'item_css_id' => 'listingsdisplay'
    ) );
  }
}

function wpachievements_bp_display_achievements() {

  if ( ! function_exists('bp_core_load_template') ) {
    return;
  }

  if ( 'Disable' != wpachievements_get_site_option('wpachievements_bp_show_achievemnets_tab') ) {
    add_action( 'bp_template_content', 'wpachievements_bp_show_achievements' );
  }

  if ( 'Disable' != wpachievements_get_site_option('wpachievements_bp_show_quests_tab') ) {
    add_action( 'bp_template_content', 'wpachievements_bp_show_quests' );
  }

  bp_core_load_template( apply_filters( 'bp_core_template_plugin', 'members/single/plugins' ) );
}

function wpachievements_bp_show_achievements() {
  wpachievements_bp_output_content( 'achievements' );
}

/**
* Show Quests in profile member Tab
*
* @static
* @access  public
* @return void
*/
function wpachievements_bp_show_quests() {
  wpachievements_bp_output_content( 'quests' );
}

/**
* Show Quests in profile member Tab
*
* @static
* @access  public
* @return void
*/
function wpachievements_bp_output_content( $screentype = 'achievements' ) {

  // Check if required functions exist
  $functions = array(
    'bp_displayed_user_id',
    'bp_get_displayed_user_fullname',
    'bp_get_user_firstname',
    'bp_core_get_username',
    'bp_is_my_profile'
  );

  foreach ( $functions as $function ) {
    if ( ! function_exists( $function ) ) {
      return;
    }
  }

  // Get User ID.
  $user_id = ! empty( $user_id ) ? $user_id : bp_displayed_user_id();
  $full_name = bp_get_displayed_user_fullname();
  $username = ! empty( bp_get_user_firstname( $full_name ) ) ? bp_get_user_firstname( $full_name ) : bp_core_get_username( $user_id );

  if ( 'achievements' == $screentype ){
    // Get Ballance
    $userbadges = get_user_meta( $user_id, 'achievements_gained', true );
    $page_title = bp_is_my_profile() ? __( 'My Achievements', 'wpachievements' ) : sprintf( __( "%1s's Achievements", "wpachievements" ), $username );
  }
  elseif ( 'quests' == $screentype ) {
    // Get Ballance
    $userbadges = get_user_meta( $user_id, 'quests_gained', true );
    $page_title = bp_is_my_profile() ? __( 'My Quests', 'wpachievements' ) : sprintf( __( "%1s's Quests", "wpachievements" ), $username );
  }

  // Get Badges Total
  $badges_total = ($userbadges) ?  count( $userbadges ) : 0;

  ?>
  <div class="wpa-bp-tab-title-box">
    <div class="wpa-bp-tab-title-icon"><i class="fa fa-trophy" aria-hidden="true"></i></div>
    <div class="wpa-bp-tab-title-content">
      <h2><?php echo $page_title; ?></h2>
      <span><?php echo sprintf( _n( '%s Badge', '%s Badges', $badges_total, 'wpachievements' ), $badges_total ); ?></span>
    </div>
  </div>

  <div class="wpa-bp-badges-tab">
    <?php
    if ( ! empty( $userbadges ) ) {
      foreach ( $userbadges as $list_id => $userbadge_id ) {
        if ( 'achievements' == $screentype ){
          $userbadge_img_url = get_post_meta( $userbadge_id, '_achievement_image', true );
        }
        elseif ( 'quests' == $screentype ) {
          $userbadge_img_url = get_post_meta( $userbadge_id, '_quest_image', true );
        }
        echo '<div class="wpa-bp-badge-item">';
        echo '<img src="'. $userbadge_img_url .'" title="'. get_the_title( $userbadge_id ) .'" alt="'. get_the_title( $userbadge_id ) .'" width="100" height="100">';
        echo '<div class="wpa-bp-badge-title">' . get_the_title( $userbadge_id ) . '</div>';
        echo '</div>';
      }
    }
    ?>
  </div>
  <?php
}


 //*************** Detect New Update ***************\\
 function wpachievements_my_bp_update_post_add( $content, $user_id, $activity_id ){
  if( !empty($user_id) ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_update',
      'user_id'     => $user_id,
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_bp_update_points'),
      'force_award' => true,
    ) );
  }
 }
 //*************** Detect New Comment or Reply ***************\\
 function wpachievements_my_bp_update_comment_add( $comment_id ){
  if( !empty($comment_id) ){
   $comment = get_comment( $comment_id );
   if( $comment->user_id ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_reply',
      'user_id'     => $comment->user_id,
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_bp_reply_points'),
      'force_award' => true,
    ) );
   }
  }
 }
 //*************** Detect Removes Comment or Reply ***************\\
 function wpachievements_my_bp_delete_comment_add( $id, $user_id ){
  if( !empty($user_id) ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_update_removed',
      'user_id'     => $user_id,
      'post_id'     => '',
      'points'      => -(int) wpachievements_get_site_option('wpachievements_bp_reply_points'),
      'force_award' => true,
    ) );
  }
 }
 //*************** Detect New Group ***************\\
 function wpachievements_my_bp_create_group_add(){
  $current_user = wp_get_current_user();
  WPAchievements_Trigger::new_activity( array(
    'activity'    => 'cp_bp_group_create',
    'user_id'     => $current_user->ID,
    'post_id'     => '',
    'points'      => (int) wpachievements_get_site_option('wpachievements_bp_group_create'),
    'force_award' => true,
  ) );
 }
 //*************** Detect Group Removed ***************\\
 function wpachievements_my_bp_create_group_remove( $id, $user_id ){
  if( !empty($user_id) ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_group_delete',
      'user_id'     => $user_id,
      'post_id'     => '',
      'points'      => -(int) wpachievements_get_site_option('wpachievements_bp_group_create'),
      'force_award' => true,
    ) );
  }
 }
 //*************** Detect Join Group ***************\\
 function wpachievements_my_bp_join_group_add( $group_id, $user_id ){
  if( !empty($user_id) ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_group_joined',
      'user_id'     => $user_id,
      'post_id'     => $group_id,
      'points'      => (int) wpachievements_get_site_option('wpachievements_bp_group_joined'),
    ) );
  }
 }

 function wpachievements_my_bp_join_non_public_group_add( $user_id, $group_id ){
  if( !empty($user_id) ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_group_joined',
      'user_id'     => $user_id,
      'post_id'     => $group_id,
      'points'      => (int) wpachievements_get_site_option('wpachievements_bp_group_joined'),
    ) );
  }
 }

 //*************** Detect Leave Group ***************\\
 function wpachievements_my_bp_leave_group_add_cppoints( $group_id, $user_id ){
  if( !empty($user_id) ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_group_left',
      'user_id'     => $user_id,
      'post_id'     => $group_id,
      'points'      => -(int) wpachievements_get_site_option('wpachievements_bp_group_joined'),
    ) );
  }
 }

 //*************** Detect New Group Reply ***************\\
 function wpachievements_my_bp_update_group_add( $content, $user_id, $group_id, $activity_id ){
  if( !empty($user_id) ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_group_reply',
      'user_id'     => $user_id,
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_bp_group_reply'),
      'force_award' => true,
    ) );
  }
 }

 //*************** Detect New Friend Added ***************\\
 function wpachievements_my_bp_friend_add($friendship_id, $inviter_id, $invitee_id){
  WPAchievements_Trigger::new_activity( array(
    'activity'    => 'cp_bp_new_friend',
    'user_id'     => $inviter_id,
    'post_id'     => '',
    'points'      => (int) wpachievements_get_site_option('wpachievements_bp_new_friend'),
    'force_award' => true,
  ) );

  WPAchievements_Trigger::new_activity( array(
    'activity'    => 'cp_bp_new_friend',
    'user_id'     => $invitee_id,
    'post_id'     => '',
    'points'      => (int) wpachievements_get_site_option('wpachievements_bp_new_friend'),
    'force_award' => true,
  ) );
 }

 //*************** Detect Friend Removed ***************\\
 function wpachievements_my_bp_friend_delete_add($friendship_id, $initiator_userid, $friend_userid){
  WPAchievements_Trigger::new_activity( array(
    'activity'    => 'cp_bp_lost_friend',
    'user_id'     => $initiator_userid,
    'post_id'     => '',
    'points'      => -(int) wpachievements_get_site_option('wpachievements_bp_new_friend'),
    'force_award' => true,
  ) );

  WPAchievements_Trigger::new_activity( array(
    'activity'    => 'cp_bp_lost_friend',
    'user_id'     => $friend_userid,
    'post_id'     => '',
    'points'      => -(int) wpachievements_get_site_option('wpachievements_bp_new_friend'),
    'force_award' => true,
  ) );
 }

 //*************** Detect New Group Topic ***************\\
 function wpachievements_my_bp_forum_new_topic_add(){
  WPAchievements_Trigger::new_activity( array(
    'activity'    => 'cp_bp_new_group_forum_topic',
    'user_id'     => '',
    'post_id'     => '',
    'points'      => (int) wpachievements_get_site_option('wpachievements_bp_new_group_forum_topic'),
    'force_award' => true,
  ) );
 }
 //*************** Detect New Group Forum Post ***************\\
 function wpachievements_my_bp_forum_new_post_add(){
  WPAchievements_Trigger::new_activity( array(
    'activity'    => 'cp_bp_new_group_forum_post',
    'user_id'     => '',
    'post_id'     => '',
    'points'      => (int) wpachievements_get_site_option('wpachievements_bp_new_group_forum_post'),
    'force_award' => true,
  ) );
 }

 //*************** Detect Edit Group Forum Post ***************\\
 function wpachievements_my_bp_forum_edit_topic_add(){
  WPAchievements_Trigger::new_activity( array(
    'activity'    => 'cp_bp_new_group_forum_post_edit',
    'user_id'     => '',
    'post_id'     => '',
    'points'      => 0,
  ) );
 }
 //*************** Detect New Avatar ***************\\
 function wpachievements_my_bp_avatar_add(){
   global $bp;
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_avatar_uploaded',
      'user_id'     => $bp->loggedin_user->id,
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_bp_avatar_uploaded'),
    ) );
 }
 //*************** Detect New Group Avatar ***************\\
 function wpachievements_my_bp_group_avatar_add(){
   global $bp;
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_group_avatar_uploaded',
      'user_id'     => $bp->loggedin_user->id,
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_bp_group_avatar_uploaded'),
    ) );
 }
 //*************** Detect User Sending a Message ***************\\
  function wpachievements_my_bp_pm(){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'cp_bp_message_sent',
      'user_id'     => '',
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_bp_message_sent'),
      'force_award' => true,
    ) );
  }

  /**
   * Check if we have a valid activity
   *
   * @param   bool $proceed True on valid activity
   * @param   string $type
   * @param   int $uid
   * @param   int $postid
   * @param   int $ach_ID
   * @return  bool
   */
  function wpachievements_bp_check_actvity( $proceed, $type, $ach_ID, $postid ) {

    switch ( $type ) {
      case 'cp_bp_group_joined': {
        $ach_group_id = get_post_meta( $ach_ID, '_achievement_associated_title', true );

        if ( $ach_group_id ) {
          $group = groups_get_group( array( 'group_id' => $postid ) );

          if ( $group ) {
            if (  $postid != $ach_group_id ) {
              $proceed = false;
            }
          }
        }
      } break;
    }

    return $proceed;
  }
  add_filter( 'wpachievements_proceed_new_activity', 'wpachievements_bp_check_actvity', 10, 4 );

 //*************** Descriptions ***************\\
 add_filter('wpachievements_activity_description', 'achievement_bp_desc', 10, 4);
 function achievement_bp_desc($text='',$type='',$points='',$times=''){
  switch($type){
   case 'cp_bp_group_create': { $text = sprintf( _n( 'for creating %s new group', 'for creating %s new groups', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_group_delete': { $text = sprintf( _n( 'for deleting %s group', 'for deleting %s groups', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_update': { $text = sprintf( _n( 'for adding %s update', 'for adding %s updates', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_group_joined': { $text = sprintf( _n( 'for joining %s group', 'for joining %s groups', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_group_left': { $text = sprintf( _n( 'for leaving %s group', 'for leaving %s groups', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_reply': { $text = sprintf( _n( 'for creating %s reply', 'for creating %s replies', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_group_reply': { $text = sprintf( _n( 'for creating %s group reply', 'for creating %s group replies', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_update_removed': { $text = sprintf( _n( 'for removing %s update', 'for removing %s updates', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_new_friend': { $text = sprintf( _n( 'for adding %s friend', 'for adding %s friends', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_lost_friend': { $text = sprintf( _n( 'for cancelling %s friendship', 'for cancelling %s friendships', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_new_group_forum_topic': { $text = sprintf( _n( 'for creating %s group forum topic', 'for creating %s group forum topics', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_new_group_forum_post': { $text = sprintf( _n( 'for creating %s new group forum post', 'for creating %s new group forum posts', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_new_group_forum_post_edit': { $text = sprintf( _n( 'for editting %s group forum post', 'for editting %s group forum posts', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_avatar_uploaded': { $text = sprintf( _n( 'for uploading %s new avatar', 'for uploading %s new avatars', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_group_avatar_uploaded': { $text = sprintf( _n( 'for uploading %s new group avatar', 'for uploading %s new group avatars', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_message_sent': { $text = sprintf( _n( 'for sending %s message', 'for sending %s messages', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_quest_description', 'quest_bp_desc', 10, 3);
 function quest_bp_desc($text='',$type='',$times=''){
  switch($type){
   case 'cp_bp_group_create': { $text = sprintf( _n( 'Create %s new group', 'Create %s new groups', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_group_delete': { $text = sprintf( _n( 'Delete %s group', 'Delete %s groups', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_update': { $text = sprintf( _n( 'Add %s update', 'Add %s updates', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_group_joined': { $text = sprintf( _n( 'Join %s group', 'Join %s groups', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_group_left': { $text = sprintf( _n( 'Leave %s group', 'Leave %s groups', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_reply': { $text = sprintf( _n( 'Create %s reply', 'Create %s replies', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_group_reply': { $text = sprintf( _n( 'Create %s group reply', 'Create %s group replies', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_update_removed': { $text = sprintf( _n( 'Remove %s update', 'Remove %s updates', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_new_friend': { $text = sprintf( _n( 'Add %s friend', 'Add %s friends', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_lost_friend': { $text = sprintf( _n( 'Cancel %s friendship', 'Cancel %s friendships', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_new_group_forum_topic': { $text = sprintf( _n( 'Create %s group forum topic', 'Create %s group forum topics', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_new_group_forum_post': { $text = sprintf( _n( 'Create %s new group forum post', 'Create %s new group forum posts', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_new_group_forum_post_edit': { $text = sprintf( _n( 'Edit %s group forum post', 'Edit %s group forum posts', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_avatar_uploaded': { $text = sprintf( _n( 'Upload %s new avatar', 'Upload %s new avatars', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_group_avatar_uploaded': { $text = sprintf( _n( 'Upload %s new group avatar', 'Upload %s new group avatars', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_message_sent': { $text = sprintf( _n( 'Send %s message', 'Send %s messages', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

add_filter( 'wpachievements_get_sections_module', 'wpachievements_add_section_bp' );
function wpachievements_add_section_bp( $sections ) {
	$sections['bp'] = __( 'BuddyPress', 'wpachievements' );
	return $sections;
}

//*************** Admin Settings ***************\\
add_filter('wpachievements_achievements_modules_admin_settings', 'wpachievements_bp_admin', 10, 3);
function wpachievements_bp_admin($defaultsettings, $shortname, $current_section){
  if ( $current_section == 'bp' ) {
    $settings[] = array( 'title' => __( 'BuddyPress', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'BuddyPress_options' );

    $settings[] = array(
      'title'   => __( 'Achievements Tab Content', 'wpachievements' ),
      'desc'    => __( 'Select to show Achievements in the user Badges tab.', 'wpachievements' ),
      'id'      => $shortname.'_bp_show_achievements_tab',
      'type'    => 'select',
      'default' => 'Enable',
      'css'     => 'min-width:300px;',
      'options' => array(
        'Enable'  => __('Enable','wpachievements' ),
        'Disable'  => __('Disable', 'wpachievements' ),
      ),
    );

    $settings[] = array(
      'title'   => __( 'Quests Tab Content', 'wpachievements' ),
      'desc'    => __( 'Select to show Quests in the user Badges tab.', 'wpachievements' ),
      'id'      =>  $shortname.'_bp_show_quests_tab',
      'type'    => 'select',
      'default' => 'Enable',
      'css'     => 'min-width:300px;',
      'options' => array(
        'Enable'  => __('Enable','wpachievements' ),
        'Disable'  => __('Disable', 'wpachievements' ),
      ),
    );

    $settings[] = array( 'type' => 'sectionend', 'id' => 'BuddyPress_options');

    $settings[] = array( 'title' => __( 'Point Settings', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'BuddyPress_points' );

    $settings[] = array(
            'title'   => __( 'User Adding Avatar', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a avatar.', 'wpachievements' ),
            'id'      => $shortname.'_bp_avatar_uploaded',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Adding Friends', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a friend.', 'wpachievements' ),
            'id'      => $shortname.'_bp_new_friend',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Sending Messages', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a message.', 'wpachievements' ),
            'id'      => $shortname.'_bp_message_sent',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Adding Update', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds an update.', 'wpachievements' ),
            'id'      => $shortname.'_bp_update_points',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Adding Reply', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a reply.', 'wpachievements' ),
            'id'      => $shortname.'_bp_reply_points',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Adding Groups', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a group.', 'wpachievements' ),
            'id'      => $shortname.'_bp_group_create',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Adding Group Avatar', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a group avatar.', 'wpachievements' ),
            'id'      => $shortname.'_bp_group_avatar_uploaded',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Joins Groups', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user joins a group.', 'wpachievements' ),
            'id'      => $shortname.'_bp_group_joined',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Adding Group Topic', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a group topic.', 'wpachievements' ),
            'id'      => $shortname.'_bp_new_group_forum_topic',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Adding Group Reply', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a group reply.', 'wpachievements' ),
            'id'      => $shortname.'_bp_group_reply',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Adding Group Forum Post', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a group forum post.', 'wpachievements' ),
            'id'      => $shortname.'_bp_new_group_forum_post',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array( 'type' => 'sectionend', 'id' => 'BuddyPress_points');

    return $settings;
  /**
  * If not, return the standard settings
  **/
	} else {
		return $defaultsettings;
	}
}

 //*************** Admin Events ***************\\
 add_filter('wpachievements_admin_events', 'achievement_bp_admin_events', 10);
 function achievement_bp_admin_events(){
   echo '<optgroup label="BuddyPress User Events">
     <option value="cp_bp_avatar_uploaded">'.__('The user uploads an avatar', 'wpachievements').'</option>
     <option value="cp_bp_message_sent">'.__('The user sends a message', 'wpachievements').'</option>
     <option value="cp_bp_new_friend">'.__('The user adds a new friend', 'wpachievements').'</option>
     <option value="cp_bp_lost_friend">'.__('The user removes a friend', 'wpachievements').'</option>
     <option value="cp_bp_update">'.__('The user adds an update', 'wpachievements').'</option>
     <option value="cp_bp_reply">'.__('The user creates a reply', 'wpachievements').'</option>
     <option value="cp_bp_update_removed">'.__('The user removes an update', 'wpachievements').'</option>
   </optgroup>
   <optgroup label="BuddyPress Group Events">
     <option value="cp_bp_group_create">'.__('The user creates a group', 'wpachievements').'</option>
     <option value="cp_bp_group_delete">'.__('The user deletes a group', 'wpachievements').'</option>
     <option value="cp_bp_group_joined">'.__('The user joins a group', 'wpachievements').'</option>
     <option value="cp_bp_group_left">'.__('The user leaves a group', 'wpachievements').'</option>
     <option value="cp_bp_group_reply">'.__('The user creates a group reply', 'wpachievements').'</option>
     <option value="cp_bp_group_avatar_uploaded">'.__('The user uploads a group avatar', 'wpachievements').'</option>
   </optgroup>
   <optgroup label="BuddyPress Forum Events">
     <option value="cp_bp_new_group_forum_topic">'.__('The user creates a new group forum topic', 'wpachievements').'</option>
     <option value="cp_bp_new_group_forum_post">'.__('The user creates a new group forum post', 'wpachievements').'</option>
     <option value="cp_bp_new_group_forum_post_edit">'.__('The user edits a group forum post', 'wpachievements').'</option>
   </optgroup>';
 }

 //*************** Admin Trigger Naming ***************\\
 add_filter('wpachievements_trigger_description', 'achievement_bp_admin_triggers', 1, 10);
 function achievement_bp_admin_triggers($trigger){

   switch($trigger){
     case 'cp_bp_avatar_uploaded': { $trigger = __('The user uploads an avatar', 'wpachievements'); } break;
     case 'cp_bp_message_sent': { $trigger = __('The user sends a message', 'wpachievements'); } break;
     case 'cp_bp_new_friend': { $trigger = __('The user adds a new friend', 'wpachievements'); } break;
     case 'cp_bp_lost_friend': { $trigger = __('The user removes a friend', 'wpachievements'); } break;
     case 'cp_bp_update': { $trigger = __('The user adds an update', 'wpachievements'); } break;
     case 'cp_bp_reply': { $trigger = __('The user creates a reply', 'wpachievements'); } break;
     case 'cp_bp_update_removed': { $trigger = __('The user removes an update', 'wpachievements'); } break;
     case 'cp_bp_group_create': { $trigger = __('The user creates a group', 'wpachievements'); } break;
     case 'cp_bp_group_delete': { $trigger = __('The user deletes a group', 'wpachievements'); } break;
     case 'cp_bp_group_joined': { $trigger = __('The user joins a group', 'wpachievements'); } break;
     case 'cp_bp_group_left': { $trigger = __('The user leaves a group', 'wpachievements'); } break;
     case 'cp_bp_group_reply': { $trigger = __('The user creates a group reply', 'wpachievements'); } break;
     case 'cp_bp_group_avatar_uploaded': { $trigger = __('The user uploads a group avatar', 'wpachievements'); } break;
     case 'cp_bp_new_group_forum_topic': { $trigger = __('The user creates a new group forum topic', 'wpachievements'); } break;
     case 'cp_bp_new_group_forum_post': { $trigger = __('The user creates a new group forum post', 'wpachievements'); } break;
     case 'cp_bp_new_group_forum_post_edit': { $trigger = __('The user edits a group forum post', 'wpachievements'); } break;
   }

   return $trigger;

 }

 /**
  *************************************************
  *    A D D I T I O N A L   F U N C T I O N S    *
  *************************************************
  */
  //*************** Actions ***************\\
  add_action('wpachievements_after_new_achievement', 'show_ach_in_stream', 10, 3);
  add_action('wpachievements_after_new_custom_achievement', 'show_ach_in_stream', 10, 3);
  add_action('wpachievements_after_new_quest', 'show_quest_in_stream', 10, 3);
  add_action('wpachievements_new_rank_gained', 'wpachievements_bp_profile_ranks', 10, 1);
  add_action( 'bp_before_member_header_meta', 'wpachievements_bp_profile' );
  //*************** Show achievement in steam ***************\\
  function show_ach_in_stream( $user_id, $ach_id, $achievement ){
   if(function_exists('bp_activity_add')){
     $message = '<img src="'.$achievement['img'].'" alt="" class="achieves_gained_badge_feed" /> '. sprintf( __('I just gained the achievement %s and got %s points!', 'wpachievements'), '<strong>'.stripslashes($achievement['title']).'</strong>', '<strong>'.$achievement['points'].'</strong>');
     $action  = bp_core_get_userlink($user_id) .' '. __('I just gained a new achievement!!!', 'wpachievements');
     bp_activity_add( array( 'user_id' => $user_id, 'content' => $message, 'action' => $action, 'component' => 'profile', 'type' => 'new_achievement' ));
   }
  }
  function show_quest_in_stream( $user_id, $quest_ID, $quest ){
   if(function_exists('bp_activity_add')){
     $message = '<img src="'.$quest['img'].'" alt="" class="achieves_gained_badge_feed" /> '. sprintf( __('I just gained the quest %s and got %s points!', 'wpachievements'), '<strong>'.stripslashes($quest['title']).'</strong>', '<strong>'.$quest['points'].'</strong>');
     $action  = bp_core_get_userlink($user_id) .' '. __('I just gained a new quest!!!', 'wpachievements');
     bp_activity_add( array( 'user_id' => $user_id, 'content' => $message, 'action' => $action, 'component' => 'profile', 'type' => 'new_achievement' ));
   }
  }

   //*************** Show new rank in steam ***************\\
   function wpachievements_bp_profile_ranks($uid){
    if(!empty($uid)){
     $usersrank = wpachievements_getRank($uid);
     $userlink = bp_core_get_userlink($uid);
     $message = sprintf( __('I was just promoted to the rank of %s', 'wpachievements'), '<strong>'.$usersrank.'</strong>');
     $action  = sprintf( __('%s gained a new rank', 'wpachievements'), $userlink);
     bp_activity_add( array( 'user_id' => $uid, 'content' => $message, 'action' => $action, 'component' => 'profile', 'type' => 'new_ranking' ));
    }
   }
   //*************** Show rank stats in profile ***************\\
   function wpachievements_bp_profile(){

    if ( 'Disable' == wpachievements_get_site_option('wpachievements_rank_status') ) {
      return;
    }

    if( apply_filters( 'wpachievements_before_bp_profile_rank', true ) ){
      global $bp;
      echo '<span class="cupepoints_buddypress_rank activity"><strong>'.__('Rank', 'wpachievements').':</strong> '.wpachievements_getRank($bp->displayed_user->id).'</span>';
    }
  }

  /**
   * Get the user profile link
   *
   * @access  public
   * @param   string $url
   * @param   int $user_id
   * @return  string
   */
  function wpachievements_bp_profile_url( $url, $user_id ) {

    if ( function_exists( 'bp_core_get_user_domain' ) ) {
      $url = bp_core_get_user_domain( $user_id );
    }

    return $url;
  }
  add_filter( 'wpachievements_user_profile_url', 'wpachievements_bp_profile_url', 10, 2 );
endif;
